/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.Launcher;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;

public class SquashMergeBranchHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        String currentBranch = repo.currentBranch();
        ArrayList<MenuDialogItem> listOfMaps = new ArrayList<MenuDialogItem>();
        for (String branch : repo.allBranches()) {
            if (branch.equals(currentBranch)) continue;
            listOfMaps.add(new MenuDialogItem(branch));
        }
        if (!listOfMaps.isEmpty()) {
            QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.SquashMergeBranchHandler_PopupTitle);
            dialog.setInput(listOfMaps);
            if (dialog.open() != -1) {
                MenuDialogItem item = (MenuDialogItem)listOfMaps.get(dialog.getReturnCode());
                SquashMergeBranchHandler.mergeBranch(repo, item.getText());
            }
        }
        return null;
    }

    public static void mergeBranch(final GitRepository repo, final String branchName) {
        Job job = new Job(NLS.bind((String)"git merge --squash {0}", (Object)branchName)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (!repo.enterWriteProcess()) {
                    return new Status(4, GitPlugin.getPluginId(), Messages.GitLaunchDelegate_FailedToAcquireWriteLock);
                }
                try {
                    try {
                        ILaunch launch = Launcher.launch(repo, (IProgressMonitor)subMonitor.newChild(75), "merge", "--squash", branchName);
                        while (!launch.isTerminated()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
                        IStatus iStatus = e.getStatus();
                        repo.exitWriteProcess();
                        return iStatus;
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
                        Status status = new Status(4, GitUIPlugin.getPluginId(), e.getMessage());
                        repo.exitWriteProcess();
                        return status;
                    }
                }
                finally {
                    repo.exitWriteProcess();
                }
                subMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }
}

